function [xvect,xdif,fx,iter] = secant(xm1,x0,tol,nmax,fun)
%SECANT Mthode de la scante tente de trouver un zro de la fonction
% continue FUN en utilisant la mthode de la scante.
% FUN accepte une variable relle scalaire x et renvoie une valeur relle scalaire. 
% XVECT est le vecteur des itres, XDIF est le vecteur des diffrences entre
% itres conscutives, FX est le rsidu. TOL est la tolrance de la mthode.
x=xm1; fxm1=eval(fun);
xvect=[x]; fx=[fxm1];
x=x0; fx0=eval(fun);
xvect=[xvect;x]; fx=[fx;fx0];
err=tol+1; iter=0; xdif=[];
while iter<nmax && err>tol
    iter=iter+1;
    x=x0-fx0*(x0-xm1)/(fx0-fxm1);
    xvect=[xvect;x];
    fnew=eval(fun); fx=[fx;fnew];
    err=abs(x0-x);
    xdif=[xdif;err];
    xm1=x0; fxm1=fx0;
    x0=x; fx0=fnew;
end
return
