function [xvect,xdif,fx,iter]=newton(x0,tol,nmax,fun,dfun)
%NEWTON mthode de Newton tente de trouver un zro de 
% la fonction continue FUN avec la mthode de Newton en 
% partant de la donne initiale X0. FUN et DFUN accepte une 
% variable relle scalaire x et renvoie une valeur relle scalaire. 
% XVECT est le vecteur des itres, XDIF est le vecteur
% des diffrences entre itres conscutives, FX est le rsidu.
% TOL est la tolrance de la mthode.
err=tol+1; iter=0; xvect=x0; x=x0; fx=eval(fun); xdif=[];
while iter<nmax && err>tol
    iter=iter+1;
    x=xvect(iter);
    dfx=eval(dfun);
    if dfx==0
        err=tol*1.e-10;
        fprintf('arrt car dfun est nulle');
    else
        xn=x-fx(iter)/dfx; err=abs(xn-x); xdif=[xdif; err];
        x=xn; xvect=[xvect;x]; fx=[fx;eval(fun)];
    end
end
return
