function [xvect,xdif,fx,iter]=bisect(a,b,tol,nmax,fun)
% BISECT Mthode de dichotomie
% [XVECT,XDIF,FX,NIT]=BISECT(A,B,TOL,NMAX,FUN) tente de trouver un zro
% de la fonction continue FUN sur lintervalle [A,B] en utilisant la mthode de dichotomie.
% FUN accepte une variable relle scalaire x et renvoie une valeur relle scalaire.
% XVECT est le vecteur des itres, XDIF est le vecteur des diffrences entre
% itres conscutives, FX est le rsidu. TOL est la tolrance de la mthode.
err=tol+1;
iter=0;
xvect=[]; fx=[]; xdif=[];
while iter<nmax && err>tol
    iter=iter+1;
    c=(a+b)/2; x=c; fc=eval(fun); xvect=[xvect;x];
    fx=[fx;fc]; x=a;
    if fc*eval(fun)>0
        a=c;
    else
        b=c;
    end
    err=0.5*abs(b-a); xdif=[xdif;err];
end
return
