function [lambda,x,iter,relres] = powerm(A, z0, tol, nmax)
%POWERM Mthode de la puissance calcule la valeur propre LAMBDA de plus grand module de la matrice A et un vecteur propre correspondant X de norme un.
% TOL est la tolrance de la mthode.
% NMAX est le nombre maximum ditrations.
% Z0 est la donne initiale.
% ITER est litration  laquelle la solution X a t calcule.

q=z0/norm(z0); 
q2=q;
relres=tol+1; 
iter=0; 
z=A*q;
while relres(end)>=tol && iter<=nmax
    q=z/norm(z); z=A*q;
    lambda=q'*z; x=q;
    z2=q2'*A; q2=z2/norm(z2); q2=q2';
    y1=q2; costheta=abs(y1'*x);
    if costheta >= 5e-2
        iter=iter+1;
        temp=norm(z-lambda*q)/costheta;
        relres=[relres; temp];
    else
        fprintf('Valeur propre multiple'); break;
    end
end
return
