function [sigma,x,iter,relres] = invpower(A, z0, mu, tol, nmax)
%INVPOWER Mthode de la puissance inverse calcule la valeur propre LAMBDA de plus petit module de la matrice A et un vecteur propre correspondant X de norme un.
% TOL est la tolrance de la mthode.
% NMAX est le nombre maximum ditrations. X0 est la donne initiale.
% MU est le shift. ITER est litration  laquelle la solution X a t calcule.
M=A-mu*eye(size(A)); [L,U,P]=lu(M);
q=z0/norm(z0); q2=q'; sigma=[];
relres=tol+1; iter=0;
while relres(end)>=tol && iter<=nmax
    iter=iter+1;
    b=P*q; y=L\b; z=U\y;
    q=z/norm(z); z=A*q; sigma=q'*z;
    b=q2'; y=U'\b; w=L'\y; q2=w'*P;
    q2=q2/norm(q2); costheta=abs(q2*q);
    if costheta>=5e-2
        temp=norm(z-sigma*q)/costheta;
        relres=[relres,temp];
    else
        fprintf('Valeur propre multiple'); break;
    end
    x=q;
end
return
