function [Q,R]=modgrams(A)
% MODGRAMS Factorisation QR dune matrice A.
% [Q,R]=MODGRAMS(A) renvoie une matrice trapzodale suprieure R
% et une matrice orthogonale Q telle que Q*R=A.
[m,n]=size(A);
Q=zeros(m,n); Q(1:m,1) = A(1:m,1); R=zeros(n); R(1,1)=1;
for k = 1:n
    R(k,k) = norm(A(1:m,k));
    Q(1:m,k) = A(1:m,k)/R(k,k);
    j = [k+1:n];
    R(k,j) = Q (1:m,k)'*A(1:m,j);
    A(1:m,j) = A (1:m,j)-Q(1:m,k)*R(k,j);
end
return
