function [b]=forwardcol(L,b)
% FORWARDCOL substitution directe: version oriente colonne.
% X=FORWARDCOL(L,B) rsout le systme triangulaire infrieur L*X=B
% avec la mthode de substitution directe dans sa version
% oriente colonne
[n,m]=size(L);
if n ~= m, error('Seulement des systmes carrs'); end
if min(abs(diag(L))) == 0, error('Le systme est singulier'); end
for j=1:n-1
  b(j)= b(j)/L(j,j);
  b(j+1:n)=b(j+1:n)-b(j)*L(j+1:n,j);
end
b(n) = b(n)/L(n,n);
return
