function [R]=chol2(A)
% CHOL2 Factorisation de Cholesky d'une matrice A symtrique dfinie positive.
% R=CHOL2(A) renvoie une matrice triangulaire suprieure R telle que R'*R=A.
[n,m]=size(A);
if n ~= m, error('Seulement les systmes carrs'); end
for k=1:n-1
if A(k,k) <= 0, error('Pivot nul ou nngatif'); end
A(k,k)=sqrt(A(k,k)); A(k+1:n,k)=A(k+1:n,k)/A(k,k);
for j=k+1:n, A(j:n,j)=A(j:n,j)-A(j:n,k)*A(j,k); end
end
A(n,n)=sqrt(A(n,n));
A = tril(A); R=A';
return
