function [A]=lukji(A)
% LUKJI Factorisation LU de la matrice A dans la version kji
% Y=LUKJI(A): U est stock dans la partie triangulaire suprieure
% de Y et L est stock dans la partie triangulaire inferieure
% stricte de Y.
[n,m]=size(A);
if n ~= m, error('Seulement les systmes carrs'); end
for k=1:n-1
if A(k,k)==0; error('Pivot nul'); end
A(k+1:n,k)=A(k+1:n,k)/A(k,k);
for j=k+1:n
i=[k+1:n]; A(i,j)=A(i,j)-A(i,k)*A(k,j);
end
end
return

