function [x,iter]=jor(A,b,x0,nmax,tol,omega)
% Mthode JOR tente de rsoudre le systme A*X=B avec la mthode JOR.
% TOL est la tolrance de la mthode. 
% NMAX est le nombre maximum d'itrations.
% X0 est la donne initiale.
% OMEGA est le paramtre de relaxation. 
% ITER est l'itration  laquelle la solution X a t calcule
[n,m]=size(A);
if n ~= m, error('Seulement les systmes carrs'); end
iter=0;
r = b-A*x0; r0=norm(r); err=norm(r); x=x0;
while err > tol && iter < nmax
iter = iter + 1;
for i=1:n
s = 0;
for j = 1:i-1, s=s+A(i,j)*x(j); end
for j = i+1:n, s=s+A(i,j)*x(j); end
xnew(i,1)=omega*(b(i)-s)/A(i,i)+(1-omega)*x(i);
end
x=xnew; r=b-A*x; err=norm(r)/r0;
end
return
