function [x]=forwardrow(L,b)
% FORWARDROW substitution directe: version oriente ligne.
% X=FORWARDROW(L,B) rsout le systme triangulaire infrieur L*X=B
% avec lamthode de substitution directe dans sa version
% oriente ligne
[n,m]=size(L);
if n ~= m, error('Seulement des systmes carrs'); end
if min(abs(diag(L))) == 0, error('Le systme est singulier'); end
x(1,1) = b(1)/L(1,1);
for i = 2:n
  x (i,1) = (b(i)-L(i,1:i-1)*x(1:i-1,1))/L(i,i);
end
return