function [x,iter]=sor(A,b,x0,nmax,tol,omega)
%SOR Mthode SOR
% [X,ITER]=SOR(A,B,X0,NMAX,TOL,OMEGA) tente de rsoudre le systme 
% A*X=B avec la mthode SOR.
% TOL est la tolrance de la mthode.
% NMAX est le nombre maximum d'itrations.
% X0 est la donne initiale.
% OMEGA est le paramtre de relaxation.
% ITER est l'itration `a laquelle la solution X a t calcule.
[n,m]=size(A);
if n ~= m, error('Seulement les systmes carrs'); end
iter=0; r=b-A*x0; r0=norm(r); err=norm(r); xold=x0;
while err > tol && iter < nmax
  iter = iter + 1;
  for i=1:n
    s=0;
    for j = 1:i-1, s=s+A(i,j)*x(j); end
    for j = i+1:n, s=s+A(i,j)*xold(j); end
    x(i,1)=omega*(b(i)-s)/A(i,i)+(1-omega)*xold(i);
  end
  xold=x; r=b-A*x; err=norm(r)/r0;
end
return
